program RSA_Angriff_D7;
(* Benchmarkversion testet Laufzeitverhalten primitiver Datentypen.
 *  - Konsolenprogramm
 *  - Auswahl zwischen bitorientierter Routine mit aufwndiger Rekursion DoPrim2()
 *    und BruteForce-Routine DoPrimBruteForce() schlicht durch Auskommentieren in main()
 *  - zu zerlegende Zahl als BigNumber definiert.
 *
 *  Anmerkung: DoPrimBruteForce() findet auch kleine Primfaktoren,
 *             DoPrim2() ignoriert diese, da RSA-Paare immer groe Primfaktoren haben
 *             (thats a bug, but also a feature)
*)

{$APPTYPE CONSOLE}
{$OPTIMIZATION ON}
uses
  SysUtils,
  MMSystem;

const
  BigNumber: int64 = 34571237124234713;

procedure DoPrimBruteForce(NumberToCrunch: int64);
var i, j, UBound: int64; UBoundC: Comp;
begin
  i := 3;
  // ohne den Umweg ber eine Gleitkommazahl
  // schafft Delphi das nicht
  UBoundC := NumberToCrunch;
  UBound := Round(Sqrt(UBoundC));
  while i < UBound do
  begin
    if NumberToCrunch mod i = 0 then
    begin
      j := NumberToCrunch div i;
      Writeln(i, ' * ', j, ' = ', j * i);
    end;
    Inc(i,2);
  end;
end;

procedure DoPrim2(NumberToCrunch: int64);
var UBound, z: int64;

  procedure Prim(
    n: Integer;   // Bitmaske bis m-te Stelle, also 2^m - 1
    m: Integer;   // Stelle (Zweierpotenz)
    i,            // 1. Kandidat fr Primzahl
    j,            // 2. Kandidat fr Primzahl
    res: int64);   // bisher auf m Stellen synthetisiertes Produkt
  var
    product: int64;
    z0: int64;
    m1, n1: Integer;
    im, jm: int64;
  begin
		product := i * j;   // berlauf? dann Ende der Rekursion

    // Rekursion bricht ab, wenn
    //   - 1. Kandidat grer als Wurzel der Zahl
    //   - Produkt zu gro
    //   - m wegen berlauf negativ wird
    if (i < UBound) and (product < z) and (m > 0) then
    begin
				z0 := z and n;   // Ausfiltern der relevanten Stellen
				m1 := m shl 1;     // nchste Stelle
				n1 := n or m1;     // Bitmaske erweitern

        // Tiefensuche rekursiv!
        // Es gibt vier mgliche Flle, je zwei pro Kandidat
        // zwei davon gehen in die Rekursion
        // relevant sind nur m Stellen

				if (res and n) = z0        // +0, +0 (i, j unverndert)
					then Prim(n1, m1, i, j, res);

				im := i or m;     // m-tes Bit der Kandidaten setzen
				jm := j or m;
        // Testen ob die letzten m Stellen des Kandidatenprodukts stimmen
        res := im * j;
        if (res and n) = z0    // +1, +0 (m-tes Bit von i gesetzt)
          then Prim(n1, m1, im, j, res);
        res := jm * i;         // +0, +1 (m-tes Bit von j gesetzt)
        if (res and n) = z0
					then Prim(n1, m1, i, jm, res);
        res := im * jm;        // +1, +1 (m-tes Bit von i,j gesetzt)
				if (res and n) = z0
					then Prim(n1, m1, im, jm, res);
    end else
    begin // Rekursion bricht ab. Stimmt das Produkt etwa?
			if (i < UBound) and (product = z)
        then Writeln(i, ' * ', j, ' = ', j * i);
    end;
  end; // Prim
var UBoundC: Comp;
begin
  z := NumberToCrunch;
  // Wurzelkriterium: ohne den Umweg ber eine Gleitkommazahl
  // schafft Delphi das nicht
  UBoundC := NumberToCrunch;
  UBound := Round(Sqrt(UBoundC));
  Prim(3, 2, 1, 1, 1);              // Start der Rekursion
end;  // DoPrim2


var STime: Cardinal;
begin
  Writeln('Delphi: Zerlege ',BigNumber);
  STime := timeGetTime;
  if (ParamCount = 0) or (AnsiUpperCase(ParamStr(1)) <> '-R') then
  begin
    Writeln('Brute Force (Aufruf mit -R = rekursives Verfahren)');
    DoPrimBruteForce(BigNumber);
  end else
  begin
    Writeln('Rekursiver Ansatz (Aufruf ohne -R = Brute Force)');
    DoPrim2(BigNumber);
  end;

  STime := timeGetTime-STime;
  Writeln('Dauer (msec): ', STime);
  Write('Weiter mit ENTER...');
  Readln;
end.


